import sys
from PyQt5.QtWidgets import *
from PyQt5 import uic
import csv_des
import des_database
from PyQt5.QtCore import *

form = uic.loadUiType("pyqt_des_ui.ui")[0]


class MyWindow(QMainWindow, form):
    def __init__(self):
        super().__init__()
        self.des_di = {"감기":1, "눈병":2, "천식":3, "피부염":4}  # city, date, des
        self.setupUi(self)

        self.cal.setCurrentPage(2014,1)

        self.cal.clicked.connect(self.get_Date)
        self.pushButton.clicked.connect(self.search)

    def get_Date(self):
        # self.cal = QCalendarWidget
        # self.cal.selectedDate()

        self.date = self.cal.selectedDate().toString()
        self.date2 = self.date[3:6].strip()

        self.fix_date = str(self.cal.yearShown()) + str(self.cal.monthShown()).zfill(2) + self.date2.zfill(2)
        print(self.fix_date)

    def search(self):
        self.city = self.comboBox.currentText()
        self.des = self.comboBox_2.currentText()

        self.num_des = self.des_di[self.des]

        print(self.city, self.fix_date, self.num_des)

        self.cities, self.nums = des_database.select_DB(self.city, self.fix_date, self.num_des)
        #self.cities, self.nums = csv_des.sum(self.city, self.fix_date, self.des)
        print(self.cities)
        print(self.nums)

        self.rows = self.cities
        self.headers = ["지역명", "발생숫자"]
        self.rows.append([self.city, str(self.nums)])

        print(self.rows)

        self.tableWidget.setRowCount(len(self.rows))
        self.tableWidget.setColumnCount(len(self.headers))
        self.tableWidget.setHorizontalHeaderLabels(self.headers)
        self.setTableWidgetData()

    def setTableWidgetData(self):
        for b in range(len(self.rows)):
            for c in range(len(self.rows[b])):
                item = QTableWidgetItem(self.rows[b][c])
                # if c == 0:
                #     item.setTextAlignment(Qt.AlignRight)
                self.tableWidget.setItem(b, c, item)


        self.tableWidget.resizeColumnsToContents()
        self.tableWidget.resizeRowsToContents()


if __name__ == '__main__':
    app = QApplication(sys.argv)
    window = MyWindow()
    window.show()
    sys.exit(app.exec_())
